# tag_macro.m
# v1.00
# 
# Comments by Todd Selden
# 20 January 1994
# 
# This file can be placed anywhere, but the genie load instruction
# in autologicrc that loads this file must have the proper path
# specified to its location.
# 
# This file contains Autologic freeware genie functions 
# that were originally written and developed by Todd Selden a member
# of SDD's Technical Advisory Group (TAG).  This file is free to distribute
# without prior constent. MENTOR GRAPHICS MAKES NO WARRANTY OF ANY KIND WITH 
# REGARD TO THIS MATERIAL.  Any suggestions or problems found can be 
# reported to tag@wv.mentorg.com.
# 

func tag_getlistcells {

   abstract cell     c 
   abstract gatetype cellname
   abstract library  lb 
 
   allcells = '()
   lb = (findlibrary @Techdef.libname)

   foreach c (cells @lb) {
      cellname = (findgatetype @c._name)
      prepend allcells @cellname._name
   }
}

func tag_compinlist {
   untyped  ucompn compnd ucompnd 

   if (isinlist @compname @allcells ) {
      return 1
   } else {
      ucompn   = (upper @compname)
      if (isinlist @ucompn @allcells ) {
         compname = @ucompn
         return 1
      } else {
         compnd   = (strtranslate "_" "-" @compname)
         if (isinlist @compnd @allcells ) {
            compname = @compnd
            return 1
         } else {
            ucompnd  = (strtranslate "_" "-" @ucompn)
            if (isinlist @ucompnd @allcells ) {
               compname = @ucompnd
               return 1
            } else {
               return 0
            }
         }
      }
   }
}

func tag_replmacro (abstract netlist nl) {

   untyped  compname p flag flag2
   abstract gatetype cellname
   abstract instance i inst
   abstract connection pin
   abstract net n
   list pinlist connlist lookup inst_list  

   inst_list = '()
   foreach inst (instances @nl) {
      if ( @inst._ismodule ) {
         flag2 = 0
         compname = (strprefix @inst.blockname ".")
         if(@compname) {
            flag2 = (tag_compinlist)
         } else { 
            compname = @inst.blockname
            while (@compname && !@flag2) {
               flag2 = (tag_compinlist)
               compname = (strprefix @compname "_")
            }
         }
         if @flag2 {
            cellname = (findgatetype @compname)
            lo_initgatetype @cellname
            if (@inst._numconns == @cellname._numpins) {
               pinlist  = '()
               connlist = '()
               lookup   = '()
               foreach pin (connections @inst) {
                  p = (upper @pin._port._portname)
                  append pinlist  @p 
                  append lookup (bld @p @pin._net)
               }
               flag = 1
               foreach p @cellname._pin {
                  n = (getref @lookup @p)
                  if (@n) {
                     append connlist (getref @lookup @p)
                  } else { 
                     flag = 0
                     println (cat "WARNING: " @inst " " @compname " port:" @p " is coded wrong.") 
                     println (cat "        library:   " @cellname._pin)
                     println (cat "        vhdl:      " @pinlist)
                  }
               }
               if @flag {
                  println (cat "    Replacing " @inst " with library part " @compname)
                  i = (addinstance @nl (assn '{
                    gatetype @cellname
                    conns @connlist
                    }))
                  prepend inst_list @inst
               }
            }
         } else {
            tag_replmacro @inst._instof._netlist
         }
      }
   } 
   if (@inst_list) {
      foreach i @inst_list {
         deleteinstance @nl @i
      }
   }
}

func tag_macroinst (args netl) {

   abstract netlist nl
   global list allcells 

   if (!@netl) {
      nl = @Netlist
   } else {
      nl = @netl
   }
   tag_getlistcells
   tag_replmacro @nl
 
}

